package gov.va.genisis2.model;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlRootElement;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

/**
 * The Class Request.
 * 
 * Description: In this Request Class implements the interface Serializable and
 * defines the entity and data mapping for the dbo.User_Approver Table in the
 * database.
 */
/**
 * @author Paramjeet Bindra
 *
 */
@Entity
@Table(name = "Request", schema = "dbo")
@XmlRootElement(name = "response")
@JsonIgnoreProperties({ "processId", "taskId", "modifiedOn", "type", "requestType", "studyApproval", "source", "type",
		"requestHistories" })
public class Request implements java.io.Serializable {

	/**
	 * serialVersionUID field for serializable class
	 */
	private static final long serialVersionUID = -8093827197557947619L;

	/** The id. */
	private int id;

	/** The process id. */
	private int processId;

	/** The title. */
	private String title;

	/** The description. */
	private String description;

	/** The status description. */
	private String statusDescription;

	/** The created on. */
	private Date createdOn;

	/** The modified on. */
	private Date modifiedOn;

	/** The created by. */
	private String createdBy;

	/** The modified by. */
	private String modifiedBy;

	/** The approver id. */
	private String approverId;

	/** The type. */
	private int type;

	/** The request histories. */
	private Set<RequestHistory> requestHistories = new HashSet<>(0);

	/** The task id. */
	private String taskId;

	/** The comments. */
	private String comments;

	/**
	 * The Request Type
	 */
	private RequestType requestType;

	/**
	 * The Study Approval
	 */
	private StudyApproval studyApproval;

	/**
	 * The source
	 */
	private Source source;

	/**
	 * The source Id for input and output Json Object
	 */
	private int sourceID;
	/**
	 * The requestType ID for input and output Json Object
	 */
	private int requestTypeID;
	/**
	 * The studyApproval ID for input and output Json Object
	 */
	private int studyApprovalID;

	/**
	 * Instantiates a new request.
	 */
	public Request() {
		// Do nothing. The method is an intentionally-blank override.
	}

	/**
	 * @param id
	 *            The Request Id
	 * @param requestType
	 *            The Request Type
	 * @param studyApproval
	 *            The Study Approval
	 * @param source
	 *            The source
	 * @param processId
	 *            The workflow Process Id
	 */
	public Request(int id, RequestType requestType, StudyApproval studyApproval, Source source, int processId) {
		this.id = id;
		this.requestType = requestType;
		this.studyApproval = studyApproval;
		this.source = source;
		this.processId = processId;
	}

	/**
	 * @param id
	 *            The Request Id
	 * @param requestType
	 *            The Request Type
	 * @param studyApproval
	 *            The Study Approval
	 * @param source
	 *            The source
	 * @param processId
	 *            The workflow Process Id
	 * @param title
	 *            The Title
	 * @param description
	 *            The Description
	 * @param statusDescription
	 *            The workflow status of this Request
	 * @param createdOn
	 *            Request creation date
	 * @param modifiedOn
	 *            Request modification date
	 * @param createdBy
	 *            Requested Created by
	 * @param modifiedBy
	 *            Request Modified by
	 * @param approverId
	 *            Request approver Id
	 * @param taskId
	 *            Request Task Id to link Comments
	 * @param requestHistories
	 *            Request Histories
	 */
	public Request(int id, RequestType requestType, StudyApproval studyApproval, Source source, int processId,
			String title, String description, String statusDescription, Date createdOn, Date modifiedOn,
			String createdBy, String modifiedBy, String approverId, String taskId,
			Set<RequestHistory> requestHistories) {
		this.id = id;
		this.requestType = requestType;
		this.studyApproval = studyApproval;
		this.source = source;
		this.processId = processId;
		this.title = title;
		this.description = description;
		this.statusDescription = statusDescription;
		this.createdOn = createdOn;
		this.modifiedOn = modifiedOn;
		this.createdBy = createdBy;
		this.modifiedBy = modifiedBy;
		this.approverId = approverId;
		this.taskId = taskId;
		this.requestHistories = requestHistories;
	}

	/**
	 * Gets the id.
	 *
	 * @return the id
	 */
	@Id
	@Column(name = "Id", unique = true, nullable = false)
	public int getId() {
		return this.id;
	}

	/**
	 * Sets the id.
	 *
	 * @param id
	 *            the new id
	 */
	public void setId(int id) {
		this.id = id;
	}

	/**
	 * Gets the process id.
	 *
	 * @return the process id
	 */
	@JsonIgnore
	@Column(name = "ProcessId", nullable = false)
	public int getProcessId() {
		return this.processId;
	}

	/**
	 * Sets the process id.
	 *
	 * @param processId
	 *            the new process id
	 */
	public void setProcessId(int processId) {
		this.processId = processId;
	}

	/**
	 * Gets the title.
	 *
	 * @return the title
	 */
	@Column(name = "Title", length = 256)
	public String getTitle() {
		return this.title;
	}

	/**
	 * Sets the title.
	 *
	 * @param title
	 *            the new title
	 */
	public void setTitle(String title) {
		this.title = title;
	}

	/**
	 * Gets the status description.
	 *
	 * @return the status description
	 */
	@Column(name = "StatusDescription", length = 50)
	public String getStatusDescription() {
		return this.statusDescription;
	}

	/**
	 * Sets the status description.
	 *
	 * @param statusDescription
	 *            the new status description
	 */
	public void setStatusDescription(String statusDescription) {
		this.statusDescription = statusDescription;
	}

	/**
	 * Gets the request type.
	 *
	 * @return the request type
	 */
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "RequestTypeId", nullable = false)
	public RequestType getRequestType() {
		return this.requestType;
	}

	/**
	 * Sets the request type.
	 *
	 * @param requestType
	 *            the new request type
	 */
	public void setRequestType(RequestType requestType) {
		this.requestType = requestType;
	}

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "StudyApprovalId", nullable = false)
	public StudyApproval getStudyApproval() {
		return this.studyApproval;
	}

	public void setStudyApproval(StudyApproval studyApproval) {
		this.studyApproval = studyApproval;
	}

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "SourceId", nullable = false)
	public Source getSource() {
		return this.source;
	}

	public void setSource(Source source) {
		this.source = source;
	}

	/**
	 * Gets the created on.
	 *
	 * @return the created on
	 */
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "CreatedOn", length = 23)
	public Date getCreatedOn() {
		return this.createdOn;
	}

	/**
	 * Sets the created on.
	 *
	 * @param createdOn
	 *            the new created on
	 */
	public void setCreatedOn(Date createdOn) {
		this.createdOn = createdOn;
	}

	/**
	 * Gets the modified on.
	 *
	 * @return the modified on
	 */
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "ModifiedOn", length = 23)
	public Date getModifiedOn() {
		return this.modifiedOn;
	}

	/**
	 * Sets the modified on.
	 *
	 * @param modifiedOn
	 *            the new modified on
	 */
	public void setModifiedOn(Date modifiedOn) {
		this.modifiedOn = modifiedOn;
	}

	/**
	 * Gets the created by.
	 *
	 * @return the created by
	 */
	@Column(name = "CreatedBy", length = 50)
	public String getCreatedBy() {
		return this.createdBy;
	}

	/**
	 * Sets the created by.
	 *
	 * @param createdBy
	 *            the new created by
	 */
	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}

	/**
	 * Gets the modified by.
	 *
	 * @return the modified by
	 */
	@Column(name = "ModifiedBy", length = 50)
	public String getModifiedBy() {
		return this.modifiedBy;
	}

	/**
	 * Sets the modified by.
	 *
	 * @param modifiedBy
	 *            the new modified by
	 */
	public void setModifiedBy(String modifiedBy) {
		this.modifiedBy = modifiedBy;
	}

	/**
	 * Gets the description.
	 *
	 * @return the description
	 */
	@Column(name = "Description", length = 3000)
	public String getDescription() {
		return description;
	}

	/**
	 * Sets the description.
	 *
	 * @param description
	 *            the new description
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * Gets the type.
	 *
	 * @return the type
	 */
	@Transient
	public int getType() {
		return type;
	}

	/**
	 * Sets the type.
	 *
	 * @param type
	 *            the new type
	 */
	public void setType(int type) {
		this.type = type;
	}

	/**
	 * Gets the approver id.
	 *
	 * @return the approver id
	 */
	@Column(name = "ApproverId", length = 50)
	public String getApproverId() {
		return approverId;
	}

	/**
	 * Sets the approver id.
	 *
	 * @param approverId
	 *            the new approver id
	 */
	public void setApproverId(String approverId) {
		this.approverId = approverId;
	}

	/**
	 * Gets the task id.
	 *
	 * @return the task id
	 */
	@Column(name = "TaskId", length = 50)
	public String getTaskId() {
		return this.taskId;
	}

	/**
	 * Sets the task id.
	 *
	 * @param taskId
	 *            the new task id
	 */
	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}

	/**
	 * Gets the request histories.
	 *
	 * @return the request histories
	 */
	@OneToMany(fetch = FetchType.LAZY, mappedBy = "request")
	public Set<RequestHistory> getRequestHistories() {
		return this.requestHistories;
	}

	public void setRequestHistories(Set<RequestHistory> requestHistories) {
		this.requestHistories = requestHistories;
	}

	/**
	 * Gets the comments.
	 *
	 * @return the comments
	 */
	@Transient
	public String getComments() {
		return comments;
	}

	/**
	 * Sets the comments.
	 *
	 * @param comments
	 *            the new comments
	 */
	public void setComments(String comments) {
		this.comments = comments;
	}

	/**
	 * @return the sourceID
	 */
	@Transient
	public int getSourceID() {
		return sourceID;
	}

	/**
	 * @param sourceID
	 *            the sourceID to set
	 */
	public void setSourceID(int sourceID) {
		this.sourceID = sourceID;
	}

	/**
	 * @return the requestTypeID
	 */
	@Transient
	public int getRequestTypeID() {
		return requestTypeID;
	}

	/**
	 * @param requestTypeID
	 *            the requestTypeID to set
	 */
	public void setRequestTypeID(int requestTypeID) {
		this.requestTypeID = requestTypeID;
	}

	/**
	 * @return the studyApprovalID
	 */
	@Transient
	public int getStudyApprovalID() {
		return studyApprovalID;
	}

	/**
	 * @param studyApprovalID
	 *            the studyApprovalID to set
	 */
	public void setStudyApprovalID(int studyApprovalID) {
		this.studyApprovalID = studyApprovalID;
	}
}
